/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.tags;

import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.util.MethodHandleHelper;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTag;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ActionTagCreate<T extends ForgeRegistryEntry<?>>
extends ActionTag<T> {
    private static final MethodHandle ID_TAG_MAP_SETTER = ActionTagCreate.link();
    private final ITagCollection<T> collection;

    public ActionTagCreate(ITagCollection<T> collection, ITag<T> tag, MCTag<?> theTag) {
        super(tag, theTag);
        this.collection = collection;
    }

    private static MethodHandle link() {
        try {
            Class<?> type = Class.forName(ITagCollection.class.getName() + "$1");
            return Arrays.stream(type.getDeclaredFields()).filter(it -> BiMap.class.isAssignableFrom(it.getType())).findFirst().map(Field::getName).map(it -> MethodHandleHelper.linkSetter(type, it)).orElseThrow(NoSuchFieldException::new);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to identify field to link to", e);
        }
    }

    @Override
    public void apply() {
        this.getIdTagMap(this.collection).put(this.getId(), this.tag);
    }

    @Override
    public boolean validate(ILogger logger) {
        if (this.collection.func_199910_a(this.getId()) != null) {
            logger.error(this.getType() + " Tag: " + this.mcTag + " already exists!");
            return false;
        }
        if (this.getIdTagMap(this.collection) instanceof ImmutableMap) {
            logger.error(this.getType() + " Tag Internal error: TagMap is " + this.collection.func_241833_a().getClass().getCanonicalName());
            return false;
        }
        return true;
    }

    @Override
    public String describe() {
        return "Registering new " + this.getType() + " tag with name " + this.mcTag;
    }

    private Map<ResourceLocation, ITag<T>> getIdTagMap(ITagCollection<T> collection) {
        Map map = collection.func_241833_a();
        if (map instanceof ImmutableBiMap) {
            HashBiMap newMap = HashBiMap.create((Map)map);
            map = newMap;
            MethodHandleHelper.invokeVoid(() -> this.lambda$getIdTagMap$2(collection, (BiMap)newMap));
        }
        return map;
    }

    private void setIdTagMap(ITagCollection<T> collection, BiMap<ResourceLocation, ITag<T>> newMap) throws Throwable {
        ID_TAG_MAP_SETTER.invoke(collection, newMap);
    }

    private /* synthetic */ void lambda$getIdTagMap$2(ITagCollection collection, BiMap newMap) throws Throwable {
        this.setIdTagMap(collection, newMap);
    }
}

